// Procedure Loader Hide
#pragma hide = 1
#pragma rtGlobals=3
#pragma rtFunctionErrors=1
#pragma IgorVersion=9
#pragma TextEncoding="UTF-8"

#pragma ModuleName=SpXZeigRStyles
#pragma version=5.00

// @brief structure to hold layout panel control values
Structure SpXZgRGraphPanelControls
	variable mode
	variable spectra
	variable axismodel
	variable axismodeb
endStructure

// @brief put the values into the structure
Static Function get_GraphDesign(STRUCT SpXZgRGraphPanelControls &gds)

	ControlInfo/W=$k_SpXZgRLayoutPanelName plotmode_cb
	gds.mode = v_value
	ControlInfo/W=$k_SpXZgRLayoutPanelName type_cb
	gds.spectra = v_value
	ControlInfo/W=$k_SpXZgRLayoutPanelName axisleftmode_cb
	gds.axismodel = v_value
	ControlInfo/W=$k_SpXZgRLayoutPanelName axisbottommode_cb
	gds.axismodeb = v_value
end

// load styles (presumes root:Packages:SpXZeigR exists, returns to root:)
// PUBLIC
// @brief call SpXZeigRStyles#load_SpXZgRStyles() to import YAML
Static Function load_SpXZgRstyles([variable reload])

	string SpXPath = SpecialDirPath("Igor Pro User Files",0,0,0) + "User Procedures:SpXZeigR"
	NewPath/Q/O SpXZeigR SpXPath

	SetDataFolder root:Packages:SpXZeigR
	if (reload == 1)
		KillDataFolder/Z Styles
		KillDataFolder/Z User
	endif
	// package defined
	NewDataFolder/O/S Styles
	import_SpXZgRYAMLFolder(0, "Graphs","graphstyle")
	import_SpXZgRYAMLFolder(0, "Spectra","spectratype")
	import_SpXZgRYAMLFolder(0, "Traces","tracestyle")
	SetDataFolder ::
	// user defined
	NewDataFolder/O/S User
	import_SpXZgRYAMLFolder(1, "Graphs","graphstyle")
	import_SpXZgRYAMLFolder(1, "Spectra","spectratype")
	import_SpXZgRYAMLFolder(1, "Traces","tracestyle")
	SetDataFolder root:

	return 0
end

// @brief import the style folder
Static Function import_SpXZgRYAMLFolder(variable which, string fldrName, string vstr)

	variable nfiles, ic, err
	string fileFilters = "(*.yml,*.yaml):.yml,.yaml;"
	string fName, fList
	
	// open a file in the folder
	PathInfo SpXZeigR
	switch(which)
		case 0:
			NewPath/O/Q YAMLFolder s_path + "SpXZgR Styles:" + fldrName
			break
		case 1:
			NewPath/O/Q YAMLFolder s_path + "User Styles:" + fldrName
			break
		default:
			break
	endswitch
	
	// set the file list to import
	fList = IndexedFile(YAMLFolder,-1,".yml") + IndexedFile(YAMLFolder,-1,".yaml")
	nfiles = ItemsInList(fList)
	if (nfiles == 0)
		return -2
	endif

	// import the files
	PathInfo YAMLFolder
	fldrName = CleanUpName(ParseFilePath(0,s_path,":",1,0),0)
	NewDataFolder/O/S $fldrName
	wave/T YAMLList = ListToTextWave(fList,";")
	for (fName : YAMLList)
		err = load_YAML("",vstr,auto=fName)
		if (err >= 0)
			wave/T YAMLWave
			recast_YAML(YAMLWave)
		endif
	endfor
	
	// clean up if desired
	killwaves/Z YAMLWave
	SetDataFolder ::
	
	return 0
end

// @brief load the YAML
Static Function load_YAML(string mstr, string vstr, [string auto])

	variable refNum, slen
	string fileFilters = "(*.yml,*.yaml):.yml,.yaml;"
	string fName
	string line = ""
	
	// make storage text wave
	make/N=(0,2)/T/O YAMLwave
	YAMLwave = ""

	// open the file	
	if (ParamIsDefault(auto))
		open/R/F=(fileFilters)/M=mstr refNum
		if (strlen(s_fileName) == 0)
			return -1
		endif
	else
		open/R/P=YAMLFolder refNum as auto
	endif
	fName = s_fileName
	
	// validate the first line
	FReadLine/Q refnum, line
	slen = strlen(line)
	if (slen != 0)
		if (cmpstr(line[0,slen-3],vstr) != 0)		
			close refNum
			return -1
		endif
	else
		close refNum
		return -1
	endif
	
	close refNum
	
	// load the text wave
	loadwave/A=YAML/J/K=2/M/V={":","",0,1}/Q fName
	fName = StringFromList(0,s_wavenames)
	wave/T yw = $fName
	if (DimSize(yw,0) != 0)
		duplicate/O/T yw YAMLwave
	endif
	killwaves/Z yw
	
	return 0
end

// @brief recast the YAML
Static Function recast_YAML(wave/T ywave)

	variable npts = DimSize(ywave,0)
	string wname
	
	duplicate/FREE/T ywave twave

	// remove tab characters and spaces before text
	twave[][] = TrimString(ReplaceString("\t",twave[p][q],""))

	// validate that name exists
	if (cmpstr(twave[1][0],"name") != 0)
		return -1
	endif
	
	// clean up wave first and last blank
	DeletePoints 0,1, twave
	if (cmpstr(twave[npts-2][0],"") == 0)
		DeletePoints (npts-2),1, twave
	endif

	// create new text wave
	wname = CleanUpName(twave[0][1],0)
	duplicate/O twave, $wname
	
	return 0
end

// @brief main call to (re)design the graph layout
Static Function design_Graph()

	STRUCT SpXZgRGraphPanelControls gds
	get_GraphDesign(gds)
	if (gds.mode != 1)
		change_graphappearance(gds)
		PopupMenu type_cb, win=$k_SpXZgRLayoutPanelName, disable=0
	else
		PopupMenu type_cb, win=$k_SpXZgRLayoutPanelName, disable=2
	endif
	return 0
end

// @brief general purpose function to change graph appearance
Static Function change_graphappearance(STRUCT SpXZgRGraphPanelControls &gds)

	string style, tStr, cmdStr
	string theWin = WinName(0,1,1)
	string titleStr = ""
	string labelpStr = ""
	string labelStr = ""
	string spectrumtype = ""
	string graphmode = ""
	string tracestyle = ""
	
	variable nstyles, ic, title, alabel
	
	// graph mode
	if (gds.mode < 8)
		DFREF sREF = $(k_SpXZgRPackageFolder + ":Styles:Graphs")
	else
		DFREF sREF = $(k_SpXZgRPackageFolder + ":User:Graphs")
	endif
	style = StringFromList(gds.mode-1,f_GraphModes())
	wave/SDFR=sREF/T gs = $style
	nstyles = DimSize(gs,0)
	
	cmdStr = "ModifyGraph/W=" + theWin + " "
	tStr = ""
	for (ic=1;ic<nstyles;ic+=1)
		if (strlen(gs[ic][1]) != 0)
			strswitch(gs[ic][0])
				case "titleprefix":
					if (strlen(gs[ic][1]) != 0)
						title = 1
						titleStr = gs[ic][1]
						if (cmpstr(titleStr,"0")==0)
							titleStr = ""
						endif
					endif
					break
				case "labelprefix":
					alabel = 1
					labelpStr = gs[ic][1]
					if (cmpstr(labelpStr,"0")==0)
						labelpStr = ""
					endif
					break
				default:
					tStr += gs[ic][0] + "=" + gs[ic][1] + ","
					break
			endswitch
		endif
	endfor	
	if (strlen(tStr) != 0)
		cmdStr += RemoveEnding(tStr)
		Execute/Z cmdStr
	endif
	
	// spectra type

	if (gds.spectra < 2)
		DFREF sREF = $(k_SpXZgRPackageFolder + ":Styles:Spectra")
	else
		DFREF sREF = $(k_SpXZgRPackageFolder + ":User:Spectra")
	endif
	style = StringFromList(gds.spectra-1,f_SpectrumTypes())
	wave/SDFR=sREF/T st = $style
	nstyles = DimSize(st,0)
	
	cmdStr = "ModifyGraph/W=" + theWin + " "
	tStr = ""
	for (ic=1;ic<nstyles;ic+=1)
		strswitch(st[ic][0])
			case "title":
				if (title == 1)
					titleStr += "\\[0" + st[ic][1]
					TextBox/C/N=title/F=0/A=LT titleStr
				else
					TextBox/K/N=title
				endif
				spectrumtype += "title:" + st[ic][1] + ";"
				break
			case "labelbottom":
				if (alabel == 1)
					labelStr = labelpStr + "\\[0" + st[ic][1]
					Label/W=$theWin bottom labelStr
				else
					Label/W=$theWin bottom ""
				endif
				spectrumtype += "labelbottom:" + st[ic][1] + ";"
				break
			case "labelleft":
				if (alabel == 1)
					labelStr =  labelpStr + "\\[0" + st[ic][1]
					Label/W=$theWin left labelStr
				else
					Label/W=$theWin left ""
				endif
				spectrumtype += "labelleft:" + st[ic][1] + ";"
				break
			case "xreverse":
				switch(gds.axismodeb)
					case 1:		// full
						if (str2num(st[ic][1]) == 1)
							SetAxis/A/R/W=$theWin bottom
						else
							SetAxis/A/W=$theWin bottom
						endif
						spectrumtype += "xreverse:" + st[ic][1] + ";"
						break
					default:
						GetAxis/Q/W=$theWin bottom
						if (str2num(st[ic][1]) == 1)
							SetAxis/W=$theWin bottom max(v_min,v_max), min(v_min,v_max)
						else
							SetAxis/W=$theWin bottom min(v_min,v_max), max(v_min,v_max)
						endif
						break
				endswitch
				break
			case "yreverse":
				switch(gds.axismodel)
					case 1:		// full
						if (str2num(st[ic][1]) == 1)
							SetAxis/A/R/W=$theWin left
						else
							SetAxis/A/W=$theWin left
						endif
						spectrumtype += "yreverse:" + st[ic][1] + ";"
						break
					default:
						GetAxis/Q/W=$theWin left
						if (str2num(st[ic][1]) == 1)
							SetAxis/W=$theWin left max(v_min,v_max), min(v_min,v_max)
						else
							SetAxis/W=$theWin left min(v_min,v_max), max(v_min,v_max)
						endif
						break
				endswitch
				break
			default:
				tStr += st[ic][0] + "=" + st[ic][1] + ","
				spectrumtype += st[ic][0] + ":" + st[ic][1] + ";"
				break
		endswitch
	endfor
	if (strlen(tStr) != 0)
		cmdStr += RemoveEnding(tStr)
		Execute/Z cmdStr
	endif
	SetWindow $WinName(0,1,1) userData(SpXZgRST) = spectrumtype
	return 0
end

// @brief list function for axes mode
// @input whichone 0 left, 1 bottom
Static Function/S f_axesmodes(variable whichone)

	string rStr = "Full;Nice;Inset;"
	rstr += SelectString(whichone,"Nice Top;Inset Top;Lock;","Nice Right;Inset Right;Lock;")
	return rstr
end
	
// @brief general purpose list functions
// @return list of spectrum types, graph modes, or trace styles
Static Function/S f_SpectrumTypes()

	string sStr, rStr
	rStr = get_StyleDir("Spectra", 0)
	sStr = get_StyleDir("Spectra", 1)
	if (strlen(sStr) != 0)
		rStr += "\\M1(-;" + sStr
	endif
	return rStr
end

// *** SPECTRA TYPES

// @brief list function for trace styles
Static Function/S f_TraceStyles()

	string sStr, rStr
	rStr = "Free;\\M1(-;" + get_StyleDir("Traces", 0)
	sStr = get_StyleDir("Traces", 1)
	if (strlen(sStr) != 0)
		rStr += "\\M1(-;" + sStr
	endif
	return rStr
end

// @brief change the trace style
Static Function change_tracestyle(variable stn)

	string style, theTrace
	if (stn < 6)
		DFREF sREF = $(k_SpXZgRPackageFolder + ":Styles:Traces")
	else
		DFREF sREF = $(k_SpXZgRPackageFolder + ":User:Traces")
	endif
	style = StringFromList(stn-1,f_TraceStyles())
	wave/SDFR=sREF/T ts = $style
	
	variable tmode, tlsize, tlstyle, nstyles, ic
	string cmdStr = "ModifyGraph "
	string tStr = ""
	
	nstyles = DimSize(ts,0)
	wave/T tList = ListToTextWave(TraceNameList(WinName(0,1),";",1+4),";")
	for (ic=1;ic<nstyles;ic+=1)
		if (strlen(ts[ic][1]) != 0)
			for (theTrace : tList)
				sprintf tStr, "%s%s(%s) = %s,", tStr, ts[ic][0], theTrace, ts[ic][1]
			endfor
		endif
	endfor
	
	cmdStr += RemoveEnding(tStr)
	Execute/Z cmdStr

	return 0
end

// *** GRAPH MODES

// @brief list function for graph modes
Static Function/S f_GraphModes()

	string sStr, rStr
	rStr = "Free;\\M1(-;" + get_StyleDir("Graphs", 0)
	sStr = get_StyleDir("Graphs", 1)
	if (strlen(sStr) != 0)
		rStr += "\\M1(-;" + sStr
	endif
	return rStr
end

// @brief get a specific style
// @return style list
Static Function/S get_StyleDir(string sloc, variable where)
	
	string kf = k_SpXZgRPackageFolder
	string slist = ""
	string objName=""
	variable ic = 0
	if (where == 0)
		DFREF dfr = $(k_SpXZgRPackageFolder + ":Styles:" + sloc)
	else
		DFREF dfr = $(k_SpXZgRPackageFolder + ":User:" + sloc)
	endif
	if (DataFolderRefStatus(dfr)==0)
		return slist
	endif
	do
		objName = GetIndexedObjNameDFR(dfr,1,ic)
		if (strlen(objName)==0)
			break
		endif
		slist += objName + ";"
		ic+=1
	while(1)
	
	sList = SortList(sList)
	
	return slist	
end
